/*
 * Decompiled with CFR 0.152.
 */
package com.shaded.fasterxml.jackson.databind.module;

import com.shaded.fasterxml.jackson.core.Version;
import com.shaded.fasterxml.jackson.databind.JsonDeserializer;
import com.shaded.fasterxml.jackson.databind.JsonSerializer;
import com.shaded.fasterxml.jackson.databind.KeyDeserializer;
import com.shaded.fasterxml.jackson.databind.Module;
import com.shaded.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.shaded.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.shaded.fasterxml.jackson.databind.jsontype.NamedType;
import com.shaded.fasterxml.jackson.databind.module.SimpleAbstractTypeResolver;
import com.shaded.fasterxml.jackson.databind.module.SimpleDeserializers;
import com.shaded.fasterxml.jackson.databind.module.SimpleKeyDeserializers;
import com.shaded.fasterxml.jackson.databind.module.SimpleSerializers;
import com.shaded.fasterxml.jackson.databind.module.SimpleValueInstantiators;
import com.shaded.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class SimpleModule
extends Module
implements Serializable {
    private static final long serialVersionUID = 3132264350026957446L;
    protected final String _name;
    protected final Version _version;
    protected SimpleSerializers _serializers = null;
    protected SimpleDeserializers _deserializers = null;
    protected SimpleSerializers _keySerializers = null;
    protected SimpleKeyDeserializers _keyDeserializers = null;
    protected SimpleAbstractTypeResolver _abstractTypes = null;
    protected SimpleValueInstantiators _valueInstantiators = null;
    protected BeanDeserializerModifier _deserializerModifier = null;
    protected BeanSerializerModifier _serializerModifier = null;
    protected HashMap<Class<?>, Class<?>> _mixins = null;
    protected LinkedHashSet<NamedType> _subtypes = null;

    public SimpleModule() {
        this._name = "SimpleModule-" + System.identityHashCode(this);
        this._version = Version.unknownVersion();
    }

    public SimpleModule(String string) {
        this(string, Version.unknownVersion());
    }

    public SimpleModule(Version version) {
        this._name = version.getArtifactId();
        this._version = version;
    }

    public SimpleModule(String string, Version version) {
        this._name = string;
        this._version = version;
    }

    public SimpleModule(String string, Version version, Map<Class<?>, JsonDeserializer<?>> map) {
        this(string, version, map, null);
    }

    public SimpleModule(String string, Version version, List<JsonSerializer<?>> list) {
        this(string, version, null, list);
    }

    public SimpleModule(String string, Version version, Map<Class<?>, JsonDeserializer<?>> map, List<JsonSerializer<?>> list) {
        this._name = string;
        this._version = version;
        if (map != null) {
            this._deserializers = new SimpleDeserializers(map);
        }
        if (list != null) {
            this._serializers = new SimpleSerializers(list);
        }
    }

    public void setSerializers(SimpleSerializers simpleSerializers) {
        this._serializers = simpleSerializers;
    }

    public void setDeserializers(SimpleDeserializers simpleDeserializers) {
        this._deserializers = simpleDeserializers;
    }

    public void setKeySerializers(SimpleSerializers simpleSerializers) {
        this._keySerializers = simpleSerializers;
    }

    public void setKeyDeserializers(SimpleKeyDeserializers simpleKeyDeserializers) {
        this._keyDeserializers = simpleKeyDeserializers;
    }

    public void setAbstractTypes(SimpleAbstractTypeResolver simpleAbstractTypeResolver) {
        this._abstractTypes = simpleAbstractTypeResolver;
    }

    public void setValueInstantiators(SimpleValueInstantiators simpleValueInstantiators) {
        this._valueInstantiators = simpleValueInstantiators;
    }

    public SimpleModule setDeserializerModifier(BeanDeserializerModifier beanDeserializerModifier) {
        this._deserializerModifier = beanDeserializerModifier;
        return this;
    }

    public SimpleModule setSerializerModifier(BeanSerializerModifier beanSerializerModifier) {
        this._serializerModifier = beanSerializerModifier;
        return this;
    }

    public SimpleModule addSerializer(JsonSerializer<?> jsonSerializer) {
        if (this._serializers == null) {
            this._serializers = new SimpleSerializers();
        }
        this._serializers.addSerializer(jsonSerializer);
        return this;
    }

    public <T> SimpleModule addSerializer(Class<? extends T> clazz, JsonSerializer<T> jsonSerializer) {
        if (this._serializers == null) {
            this._serializers = new SimpleSerializers();
        }
        this._serializers.addSerializer(clazz, jsonSerializer);
        return this;
    }

    public <T> SimpleModule addKeySerializer(Class<? extends T> clazz, JsonSerializer<T> jsonSerializer) {
        if (this._keySerializers == null) {
            this._keySerializers = new SimpleSerializers();
        }
        this._keySerializers.addSerializer(clazz, jsonSerializer);
        return this;
    }

    public <T> SimpleModule addDeserializer(Class<T> clazz, JsonDeserializer<? extends T> jsonDeserializer) {
        if (this._deserializers == null) {
            this._deserializers = new SimpleDeserializers();
        }
        this._deserializers.addDeserializer(clazz, jsonDeserializer);
        return this;
    }

    public SimpleModule addKeyDeserializer(Class<?> clazz, KeyDeserializer keyDeserializer) {
        if (this._keyDeserializers == null) {
            this._keyDeserializers = new SimpleKeyDeserializers();
        }
        this._keyDeserializers.addDeserializer(clazz, keyDeserializer);
        return this;
    }

    public <T> SimpleModule addAbstractTypeMapping(Class<T> clazz, Class<? extends T> clazz2) {
        if (this._abstractTypes == null) {
            this._abstractTypes = new SimpleAbstractTypeResolver();
        }
        this._abstractTypes = this._abstractTypes.addMapping(clazz, clazz2);
        return this;
    }

    public SimpleModule addValueInstantiator(Class<?> clazz, ValueInstantiator valueInstantiator) {
        if (this._valueInstantiators == null) {
            this._valueInstantiators = new SimpleValueInstantiators();
        }
        this._valueInstantiators = this._valueInstantiators.addValueInstantiator(clazz, valueInstantiator);
        return this;
    }

    public SimpleModule registerSubtypes(Class<?> ... classArray) {
        if (this._subtypes == null) {
            this._subtypes = new LinkedHashSet(Math.max(16, classArray.length));
        }
        for (Class<?> clazz : classArray) {
            this._subtypes.add(new NamedType(clazz));
        }
        return this;
    }

    public SimpleModule registerSubtypes(NamedType ... namedTypeArray) {
        if (this._subtypes == null) {
            this._subtypes = new LinkedHashSet(Math.max(16, namedTypeArray.length));
        }
        for (NamedType namedType : namedTypeArray) {
            this._subtypes.add(namedType);
        }
        return this;
    }

    public SimpleModule setMixInAnnotation(Class<?> clazz, Class<?> clazz2) {
        if (this._mixins == null) {
            this._mixins = new HashMap();
        }
        this._mixins.put(clazz, clazz2);
        return this;
    }

    @Override
    public String getModuleName() {
        return this._name;
    }

    @Override
    public void setupModule(Module.SetupContext setupContext) {
        if (this._serializers != null) {
            setupContext.addSerializers(this._serializers);
        }
        if (this._deserializers != null) {
            setupContext.addDeserializers(this._deserializers);
        }
        if (this._keySerializers != null) {
            setupContext.addKeySerializers(this._keySerializers);
        }
        if (this._keyDeserializers != null) {
            setupContext.addKeyDeserializers(this._keyDeserializers);
        }
        if (this._abstractTypes != null) {
            setupContext.addAbstractTypeResolver(this._abstractTypes);
        }
        if (this._valueInstantiators != null) {
            setupContext.addValueInstantiators(this._valueInstantiators);
        }
        if (this._deserializerModifier != null) {
            setupContext.addBeanDeserializerModifier(this._deserializerModifier);
        }
        if (this._serializerModifier != null) {
            setupContext.addBeanSerializerModifier(this._serializerModifier);
        }
        if (this._subtypes != null && this._subtypes.size() > 0) {
            setupContext.registerSubtypes(this._subtypes.toArray(new NamedType[this._subtypes.size()]));
        }
        if (this._mixins != null) {
            for (Map.Entry<Class<?>, Class<?>> entry : this._mixins.entrySet()) {
                setupContext.setMixInAnnotations(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public Version version() {
        return this._version;
    }
}

