/*
 * Decompiled with CFR 0.152.
 */
package com.shaded.fasterxml.jackson.databind.introspect;

import com.shaded.fasterxml.jackson.databind.JavaType;
import com.shaded.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.shaded.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import com.shaded.fasterxml.jackson.databind.introspect.AnnotationMap;
import com.shaded.fasterxml.jackson.databind.type.TypeFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.lang.reflect.Type;

public final class AnnotatedParameter
extends AnnotatedMember {
    private static final long serialVersionUID = 1L;
    protected final AnnotatedWithParams _owner;
    protected final Type _type;
    protected final int _index;

    public AnnotatedParameter(AnnotatedWithParams annotatedWithParams, Type type, AnnotationMap annotationMap, int n) {
        super(annotationMap);
        this._owner = annotatedWithParams;
        this._type = type;
        this._index = n;
    }

    @Override
    public AnnotatedParameter withAnnotations(AnnotationMap annotationMap) {
        if (annotationMap == this._annotations) {
            return this;
        }
        return this._owner.replaceParameterAnnotations(this._index, annotationMap);
    }

    @Override
    public AnnotatedElement getAnnotated() {
        return null;
    }

    @Override
    public int getModifiers() {
        return this._owner.getModifiers();
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> clazz) {
        return this._annotations == null ? null : (A)this._annotations.get(clazz);
    }

    @Override
    public Type getGenericType() {
        return this._type;
    }

    @Override
    public Class<?> getRawType() {
        if (this._type instanceof Class) {
            return (Class)this._type;
        }
        JavaType javaType = TypeFactory.defaultInstance().constructType(this._type);
        return javaType.getRawClass();
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this._owner.getDeclaringClass();
    }

    @Override
    public Member getMember() {
        return this._owner.getMember();
    }

    @Override
    public void setValue(Object object, Object object2) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot call setValue() on constructor parameter of " + this.getDeclaringClass().getName());
    }

    @Override
    public Object getValue(Object object) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot call getValue() on constructor parameter of " + this.getDeclaringClass().getName());
    }

    public Type getParameterType() {
        return this._type;
    }

    public AnnotatedWithParams getOwner() {
        return this._owner;
    }

    public int getIndex() {
        return this._index;
    }

    public String toString() {
        return "[parameter #" + this.getIndex() + ", annotations: " + this._annotations + "]";
    }
}

