/*
 * Decompiled with CFR 0.152.
 */
package com.shaded.fasterxml.jackson.databind.deser.std;

import com.shaded.fasterxml.jackson.core.Base64Variants;
import com.shaded.fasterxml.jackson.core.JsonParser;
import com.shaded.fasterxml.jackson.core.JsonProcessingException;
import com.shaded.fasterxml.jackson.core.JsonToken;
import com.shaded.fasterxml.jackson.databind.DeserializationContext;
import com.shaded.fasterxml.jackson.databind.DeserializationFeature;
import com.shaded.fasterxml.jackson.databind.JsonDeserializer;
import com.shaded.fasterxml.jackson.databind.JsonMappingException;
import com.shaded.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.shaded.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.shaded.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.shaded.fasterxml.jackson.databind.util.ArrayBuilders;
import com.shaded.fasterxml.jackson.databind.util.PrimitiveArrayBuilder;
import java.io.IOException;

public abstract class PrimitiveArrayDeserializers<T>
extends StdDeserializer<T> {
    protected PrimitiveArrayDeserializers(Class<T> clazz) {
        super(clazz);
    }

    public static JsonDeserializer<?> forType(Class<?> clazz) {
        if (clazz == Integer.TYPE) {
            return IntDeser.instance;
        }
        if (clazz == Long.TYPE) {
            return LongDeser.instance;
        }
        if (clazz == Byte.TYPE) {
            return new ByteDeser();
        }
        if (clazz == Short.TYPE) {
            return new ShortDeser();
        }
        if (clazz == Float.TYPE) {
            return new FloatDeser();
        }
        if (clazz == Double.TYPE) {
            return new DoubleDeser();
        }
        if (clazz == Boolean.TYPE) {
            return new BooleanDeser();
        }
        if (clazz == Character.TYPE) {
            return new CharDeser();
        }
        throw new IllegalStateException();
    }

    @Override
    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) throws IOException, JsonProcessingException {
        return typeDeserializer.deserializeTypedFromArray(jsonParser, deserializationContext);
    }

    @JacksonStdImpl
    static final class DoubleDeser
    extends PrimitiveArrayDeserializers<double[]> {
        private static final long serialVersionUID = 1L;

        public DoubleDeser() {
            super(double[].class);
        }

        @Override
        public double[] deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            if (!jsonParser.isExpectedStartArrayToken()) {
                return this.handleNonArray(jsonParser, deserializationContext);
            }
            ArrayBuilders.DoubleBuilder doubleBuilder = deserializationContext.getArrayBuilders().getDoubleBuilder();
            double[] dArray = (double[])doubleBuilder.resetAndStart();
            int n = 0;
            while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                double d = this._parseDoublePrimitive(jsonParser, deserializationContext);
                if (n >= dArray.length) {
                    dArray = doubleBuilder.appendCompletedChunk(dArray, n);
                    n = 0;
                }
                dArray[n++] = d;
            }
            return doubleBuilder.completeAndClearBuffer(dArray, n);
        }

        private final double[] handleNonArray(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            if (jsonParser.getCurrentToken() == JsonToken.VALUE_STRING && deserializationContext.isEnabled(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT) && jsonParser.getText().length() == 0) {
                return null;
            }
            if (!deserializationContext.isEnabled(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY)) {
                throw deserializationContext.mappingException(this._valueClass);
            }
            return new double[]{this._parseDoublePrimitive(jsonParser, deserializationContext)};
        }
    }

    @JacksonStdImpl
    static final class FloatDeser
    extends PrimitiveArrayDeserializers<float[]> {
        private static final long serialVersionUID = 1L;

        public FloatDeser() {
            super(float[].class);
        }

        @Override
        public float[] deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            if (!jsonParser.isExpectedStartArrayToken()) {
                return this.handleNonArray(jsonParser, deserializationContext);
            }
            ArrayBuilders.FloatBuilder floatBuilder = deserializationContext.getArrayBuilders().getFloatBuilder();
            float[] fArray = (float[])floatBuilder.resetAndStart();
            int n = 0;
            while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                float f = this._parseFloatPrimitive(jsonParser, deserializationContext);
                if (n >= fArray.length) {
                    fArray = floatBuilder.appendCompletedChunk(fArray, n);
                    n = 0;
                }
                fArray[n++] = f;
            }
            return floatBuilder.completeAndClearBuffer(fArray, n);
        }

        private final float[] handleNonArray(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            if (jsonParser.getCurrentToken() == JsonToken.VALUE_STRING && deserializationContext.isEnabled(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT) && jsonParser.getText().length() == 0) {
                return null;
            }
            if (!deserializationContext.isEnabled(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY)) {
                throw deserializationContext.mappingException(this._valueClass);
            }
            return new float[]{this._parseFloatPrimitive(jsonParser, deserializationContext)};
        }
    }

    @JacksonStdImpl
    static final class LongDeser
    extends PrimitiveArrayDeserializers<long[]> {
        private static final long serialVersionUID = 1L;
        public static final LongDeser instance = new LongDeser();

        public LongDeser() {
            super(long[].class);
        }

        @Override
        public long[] deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            if (!jsonParser.isExpectedStartArrayToken()) {
                return this.handleNonArray(jsonParser, deserializationContext);
            }
            ArrayBuilders.LongBuilder longBuilder = deserializationContext.getArrayBuilders().getLongBuilder();
            long[] lArray = (long[])longBuilder.resetAndStart();
            int n = 0;
            while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                long l = this._parseLongPrimitive(jsonParser, deserializationContext);
                if (n >= lArray.length) {
                    lArray = longBuilder.appendCompletedChunk(lArray, n);
                    n = 0;
                }
                lArray[n++] = l;
            }
            return longBuilder.completeAndClearBuffer(lArray, n);
        }

        private final long[] handleNonArray(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            if (jsonParser.getCurrentToken() == JsonToken.VALUE_STRING && deserializationContext.isEnabled(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT) && jsonParser.getText().length() == 0) {
                return null;
            }
            if (!deserializationContext.isEnabled(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY)) {
                throw deserializationContext.mappingException(this._valueClass);
            }
            return new long[]{this._parseLongPrimitive(jsonParser, deserializationContext)};
        }
    }

    @JacksonStdImpl
    static final class IntDeser
    extends PrimitiveArrayDeserializers<int[]> {
        private static final long serialVersionUID = 1L;
        public static final IntDeser instance = new IntDeser();

        public IntDeser() {
            super(int[].class);
        }

        @Override
        public int[] deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            if (!jsonParser.isExpectedStartArrayToken()) {
                return this.handleNonArray(jsonParser, deserializationContext);
            }
            ArrayBuilders.IntBuilder intBuilder = deserializationContext.getArrayBuilders().getIntBuilder();
            int[] nArray = (int[])intBuilder.resetAndStart();
            int n = 0;
            while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                int n2 = this._parseIntPrimitive(jsonParser, deserializationContext);
                if (n >= nArray.length) {
                    nArray = intBuilder.appendCompletedChunk(nArray, n);
                    n = 0;
                }
                nArray[n++] = n2;
            }
            return intBuilder.completeAndClearBuffer(nArray, n);
        }

        private final int[] handleNonArray(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            if (jsonParser.getCurrentToken() == JsonToken.VALUE_STRING && deserializationContext.isEnabled(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT) && jsonParser.getText().length() == 0) {
                return null;
            }
            if (!deserializationContext.isEnabled(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY)) {
                throw deserializationContext.mappingException(this._valueClass);
            }
            return new int[]{this._parseIntPrimitive(jsonParser, deserializationContext)};
        }
    }

    @JacksonStdImpl
    static final class ShortDeser
    extends PrimitiveArrayDeserializers<short[]> {
        private static final long serialVersionUID = 1L;

        public ShortDeser() {
            super(short[].class);
        }

        @Override
        public short[] deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            if (!jsonParser.isExpectedStartArrayToken()) {
                return this.handleNonArray(jsonParser, deserializationContext);
            }
            ArrayBuilders.ShortBuilder shortBuilder = deserializationContext.getArrayBuilders().getShortBuilder();
            short[] sArray = (short[])shortBuilder.resetAndStart();
            int n = 0;
            while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                short s = this._parseShortPrimitive(jsonParser, deserializationContext);
                if (n >= sArray.length) {
                    sArray = shortBuilder.appendCompletedChunk(sArray, n);
                    n = 0;
                }
                sArray[n++] = s;
            }
            return shortBuilder.completeAndClearBuffer(sArray, n);
        }

        private final short[] handleNonArray(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            if (jsonParser.getCurrentToken() == JsonToken.VALUE_STRING && deserializationContext.isEnabled(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT) && jsonParser.getText().length() == 0) {
                return null;
            }
            if (!deserializationContext.isEnabled(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY)) {
                throw deserializationContext.mappingException(this._valueClass);
            }
            return new short[]{this._parseShortPrimitive(jsonParser, deserializationContext)};
        }
    }

    @JacksonStdImpl
    static final class ByteDeser
    extends PrimitiveArrayDeserializers<byte[]> {
        private static final long serialVersionUID = 1L;

        public ByteDeser() {
            super(byte[].class);
        }

        @Override
        public byte[] deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            Object object;
            JsonToken jsonToken = jsonParser.getCurrentToken();
            if (jsonToken == JsonToken.VALUE_STRING) {
                return jsonParser.getBinaryValue(deserializationContext.getBase64Variant());
            }
            if (jsonToken == JsonToken.VALUE_EMBEDDED_OBJECT) {
                object = jsonParser.getEmbeddedObject();
                if (object == null) {
                    return null;
                }
                if (object instanceof byte[]) {
                    return (byte[])object;
                }
            }
            if (!jsonParser.isExpectedStartArrayToken()) {
                return this.handleNonArray(jsonParser, deserializationContext);
            }
            object = deserializationContext.getArrayBuilders().getByteBuilder();
            byte[] byArray = (byte[])((PrimitiveArrayBuilder)object).resetAndStart();
            int n = 0;
            while ((jsonToken = jsonParser.nextToken()) != JsonToken.END_ARRAY) {
                byte by;
                if (jsonToken == JsonToken.VALUE_NUMBER_INT || jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
                    by = jsonParser.getByteValue();
                } else {
                    if (jsonToken != JsonToken.VALUE_NULL) {
                        throw deserializationContext.mappingException(this._valueClass.getComponentType());
                    }
                    by = 0;
                }
                if (n >= byArray.length) {
                    byArray = ((PrimitiveArrayBuilder)object).appendCompletedChunk(byArray, n);
                    n = 0;
                }
                byArray[n++] = by;
            }
            return ((PrimitiveArrayBuilder)object).completeAndClearBuffer(byArray, n);
        }

        private final byte[] handleNonArray(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            byte by;
            if (jsonParser.getCurrentToken() == JsonToken.VALUE_STRING && deserializationContext.isEnabled(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT) && jsonParser.getText().length() == 0) {
                return null;
            }
            if (!deserializationContext.isEnabled(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY)) {
                throw deserializationContext.mappingException(this._valueClass);
            }
            JsonToken jsonToken = jsonParser.getCurrentToken();
            if (jsonToken == JsonToken.VALUE_NUMBER_INT || jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
                by = jsonParser.getByteValue();
            } else {
                if (jsonToken != JsonToken.VALUE_NULL) {
                    throw deserializationContext.mappingException(this._valueClass.getComponentType());
                }
                by = 0;
            }
            return new byte[]{by};
        }
    }

    @JacksonStdImpl
    static final class BooleanDeser
    extends PrimitiveArrayDeserializers<boolean[]> {
        private static final long serialVersionUID = 1L;

        public BooleanDeser() {
            super(boolean[].class);
        }

        @Override
        public boolean[] deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            if (!jsonParser.isExpectedStartArrayToken()) {
                return this.handleNonArray(jsonParser, deserializationContext);
            }
            ArrayBuilders.BooleanBuilder booleanBuilder = deserializationContext.getArrayBuilders().getBooleanBuilder();
            boolean[] blArray = (boolean[])booleanBuilder.resetAndStart();
            int n = 0;
            while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                boolean bl = this._parseBooleanPrimitive(jsonParser, deserializationContext);
                if (n >= blArray.length) {
                    blArray = booleanBuilder.appendCompletedChunk(blArray, n);
                    n = 0;
                }
                blArray[n++] = bl;
            }
            return booleanBuilder.completeAndClearBuffer(blArray, n);
        }

        private final boolean[] handleNonArray(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            if (jsonParser.getCurrentToken() == JsonToken.VALUE_STRING && deserializationContext.isEnabled(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT) && jsonParser.getText().length() == 0) {
                return null;
            }
            if (!deserializationContext.isEnabled(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY)) {
                throw deserializationContext.mappingException(this._valueClass);
            }
            return new boolean[]{this._parseBooleanPrimitive(jsonParser, deserializationContext)};
        }
    }

    @JacksonStdImpl
    static final class CharDeser
    extends PrimitiveArrayDeserializers<char[]> {
        private static final long serialVersionUID = 1L;

        public CharDeser() {
            super(char[].class);
        }

        @Override
        public char[] deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            JsonToken jsonToken = jsonParser.getCurrentToken();
            if (jsonToken == JsonToken.VALUE_STRING) {
                char[] cArray = jsonParser.getTextCharacters();
                int n = jsonParser.getTextOffset();
                int n2 = jsonParser.getTextLength();
                char[] cArray2 = new char[n2];
                System.arraycopy(cArray, n, cArray2, 0, n2);
                return cArray2;
            }
            if (jsonParser.isExpectedStartArrayToken()) {
                StringBuilder stringBuilder = new StringBuilder(64);
                while ((jsonToken = jsonParser.nextToken()) != JsonToken.END_ARRAY) {
                    if (jsonToken != JsonToken.VALUE_STRING) {
                        throw deserializationContext.mappingException(Character.TYPE);
                    }
                    String string = jsonParser.getText();
                    if (string.length() != 1) {
                        throw JsonMappingException.from(jsonParser, "Can not convert a JSON String of length " + string.length() + " into a char element of char array");
                    }
                    stringBuilder.append(string.charAt(0));
                }
                return stringBuilder.toString().toCharArray();
            }
            if (jsonToken == JsonToken.VALUE_EMBEDDED_OBJECT) {
                Object object = jsonParser.getEmbeddedObject();
                if (object == null) {
                    return null;
                }
                if (object instanceof char[]) {
                    return (char[])object;
                }
                if (object instanceof String) {
                    return ((String)object).toCharArray();
                }
                if (object instanceof byte[]) {
                    return Base64Variants.getDefaultVariant().encode((byte[])object, false).toCharArray();
                }
            }
            throw deserializationContext.mappingException(this._valueClass);
        }
    }
}

