/*
 * Decompiled with CFR 0.152.
 */
package com.shaded.fasterxml.jackson.databind.deser.impl;

import com.shaded.fasterxml.jackson.core.JsonParser;
import com.shaded.fasterxml.jackson.databind.DeserializationContext;
import com.shaded.fasterxml.jackson.databind.JsonDeserializer;
import com.shaded.fasterxml.jackson.databind.JsonMappingException;
import com.shaded.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.shaded.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.shaded.fasterxml.jackson.databind.deser.impl.ObjectIdReader;
import com.shaded.fasterxml.jackson.databind.deser.impl.PropertyValue;
import com.shaded.fasterxml.jackson.databind.deser.impl.PropertyValueBuffer;
import com.shaded.fasterxml.jackson.databind.util.ClassUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;

public final class PropertyBasedCreator {
    protected final ValueInstantiator _valueInstantiator;
    protected final HashMap<String, SettableBeanProperty> _properties;
    protected final int _propertyCount;
    protected final Object[] _defaultValues;
    protected final SettableBeanProperty[] _propertiesWithInjectables;

    protected PropertyBasedCreator(ValueInstantiator valueInstantiator, SettableBeanProperty[] settableBeanPropertyArray, Object[] objectArray) {
        int n;
        this._valueInstantiator = valueInstantiator;
        this._properties = new HashMap();
        SettableBeanProperty[] settableBeanPropertyArray2 = null;
        this._propertyCount = n = settableBeanPropertyArray.length;
        for (int i = 0; i < n; ++i) {
            SettableBeanProperty settableBeanProperty = settableBeanPropertyArray[i];
            this._properties.put(settableBeanProperty.getName(), settableBeanProperty);
            Object object = settableBeanProperty.getInjectableValueId();
            if (object == null) continue;
            if (settableBeanPropertyArray2 == null) {
                settableBeanPropertyArray2 = new SettableBeanProperty[n];
            }
            settableBeanPropertyArray2[i] = settableBeanProperty;
        }
        this._defaultValues = objectArray;
        this._propertiesWithInjectables = settableBeanPropertyArray2;
    }

    public static PropertyBasedCreator construct(DeserializationContext deserializationContext, ValueInstantiator valueInstantiator, SettableBeanProperty[] settableBeanPropertyArray) throws JsonMappingException {
        int n = settableBeanPropertyArray.length;
        SettableBeanProperty[] settableBeanPropertyArray2 = new SettableBeanProperty[n];
        Object[] objectArray = null;
        for (int i = 0; i < n; ++i) {
            Object object;
            SettableBeanProperty settableBeanProperty = settableBeanPropertyArray[i];
            if (!settableBeanProperty.hasValueDeserializer()) {
                settableBeanProperty = settableBeanProperty.withValueDeserializer(deserializationContext.findContextualValueDeserializer(settableBeanProperty.getType(), settableBeanProperty));
            }
            settableBeanPropertyArray2[i] = settableBeanProperty;
            JsonDeserializer<Object> jsonDeserializer = settableBeanProperty.getValueDeserializer();
            Object object2 = object = jsonDeserializer == null ? null : jsonDeserializer.getNullValue();
            if (object == null && settableBeanProperty.getType().isPrimitive()) {
                object = ClassUtil.defaultValue(settableBeanProperty.getType().getRawClass());
            }
            if (object == null) continue;
            if (objectArray == null) {
                objectArray = new Object[n];
            }
            objectArray[i] = object;
        }
        return new PropertyBasedCreator(valueInstantiator, settableBeanPropertyArray2, objectArray);
    }

    public void assignDeserializer(SettableBeanProperty settableBeanProperty, JsonDeserializer<Object> jsonDeserializer) {
        settableBeanProperty = settableBeanProperty.withValueDeserializer(jsonDeserializer);
        this._properties.put(settableBeanProperty.getName(), settableBeanProperty);
    }

    public Collection<SettableBeanProperty> properties() {
        return this._properties.values();
    }

    public SettableBeanProperty findCreatorProperty(String string) {
        return this._properties.get(string);
    }

    public PropertyValueBuffer startBuilding(JsonParser jsonParser, DeserializationContext deserializationContext, ObjectIdReader objectIdReader) {
        PropertyValueBuffer propertyValueBuffer = new PropertyValueBuffer(jsonParser, deserializationContext, this._propertyCount, objectIdReader);
        if (this._propertiesWithInjectables != null) {
            propertyValueBuffer.inject(this._propertiesWithInjectables);
        }
        return propertyValueBuffer;
    }

    public Object build(DeserializationContext deserializationContext, PropertyValueBuffer propertyValueBuffer) throws IOException {
        Object object = this._valueInstantiator.createFromObjectWith(deserializationContext, propertyValueBuffer.getParameters(this._defaultValues));
        object = propertyValueBuffer.handleIdValue(deserializationContext, object);
        PropertyValue propertyValue = propertyValueBuffer.buffered();
        while (propertyValue != null) {
            propertyValue.assign(object);
            propertyValue = propertyValue.next;
        }
        return object;
    }
}

