/*
 * Decompiled with CFR 0.152.
 */
package com.shaded.fasterxml.jackson.core;

import com.shaded.fasterxml.jackson.core.JsonLocation;
import java.io.IOException;

public class JsonProcessingException
extends IOException {
    static final long serialVersionUID = 123L;
    protected JsonLocation _location;

    protected JsonProcessingException(String string, JsonLocation jsonLocation, Throwable throwable) {
        super(string);
        if (throwable != null) {
            this.initCause(throwable);
        }
        this._location = jsonLocation;
    }

    protected JsonProcessingException(String string) {
        super(string);
    }

    protected JsonProcessingException(String string, JsonLocation jsonLocation) {
        this(string, jsonLocation, null);
    }

    protected JsonProcessingException(String string, Throwable throwable) {
        this(string, null, throwable);
    }

    protected JsonProcessingException(Throwable throwable) {
        this(null, null, throwable);
    }

    public JsonLocation getLocation() {
        return this._location;
    }

    public String getOriginalMessage() {
        return super.getMessage();
    }

    protected String getMessageSuffix() {
        return null;
    }

    @Override
    public String getMessage() {
        String string = super.getMessage();
        if (string == null) {
            string = "N/A";
        }
        JsonLocation jsonLocation = this.getLocation();
        String string2 = this.getMessageSuffix();
        if (jsonLocation != null || string2 != null) {
            StringBuilder stringBuilder = new StringBuilder(100);
            stringBuilder.append(string);
            if (string2 != null) {
                stringBuilder.append(string2);
            }
            if (jsonLocation != null) {
                stringBuilder.append('\n');
                stringBuilder.append(" at ");
                stringBuilder.append(jsonLocation.toString());
            }
            string = stringBuilder.toString();
        }
        return string;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + ": " + this.getMessage();
    }
}

