/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.client.snapshot;

import com.firebase.client.FirebaseException;
import com.firebase.client.snapshot.DeferredValueNode;
import com.firebase.client.snapshot.DoubleNode;
import com.firebase.client.snapshot.EmptyNode;
import com.firebase.client.snapshot.LongNode;
import com.firebase.client.snapshot.Node;
import com.firebase.client.snapshot.NodeUtilities;
import com.firebase.client.snapshot.StringNode;

public class PriorityUtilities {
    public static Node NullPriority() {
        return EmptyNode.Empty();
    }

    public static boolean isValidPriority(Node priority) {
        return priority.getPriority().isEmpty() && (priority.isEmpty() || priority instanceof DoubleNode || priority instanceof StringNode || priority instanceof DeferredValueNode);
    }

    public static Node parsePriority(Object value) {
        Node priority = NodeUtilities.NodeFromJSON(value);
        if (priority instanceof LongNode) {
            priority = new DoubleNode((double)((Long)priority.getValue()), PriorityUtilities.NullPriority());
        }
        if (!PriorityUtilities.isValidPriority(priority)) {
            throw new FirebaseException("Invalid Firebase priority (must be a string, double, ServerValue, or null)");
        }
        return priority;
    }
}

