/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.client.snapshot;

import com.firebase.client.snapshot.ChildKey;
import com.firebase.client.snapshot.Index;
import com.firebase.client.snapshot.NamedNode;
import com.firebase.client.snapshot.Node;
import com.firebase.client.snapshot.NodeUtilities;
import com.firebase.client.snapshot.StringNode;

public class PriorityIndex
extends Index {
    private static final PriorityIndex INSTANCE = new PriorityIndex();

    public static PriorityIndex getInstance() {
        return INSTANCE;
    }

    private PriorityIndex() {
    }

    @Override
    public int compare(NamedNode a, NamedNode b) {
        Node aPrio = a.getNode().getPriority();
        Node bPrio = b.getNode().getPriority();
        return NodeUtilities.nameAndPriorityCompare(a.getName(), aPrio, b.getName(), bPrio);
    }

    @Override
    public boolean isDefinedOn(Node a) {
        return !a.getPriority().isEmpty();
    }

    @Override
    public NamedNode makePost(ChildKey name, Node value) {
        return new NamedNode(name, new StringNode("[PRIORITY-POST]", value));
    }

    @Override
    public NamedNode maxPost() {
        return this.makePost(ChildKey.getMaxName(), Node.MAX_NODE);
    }

    @Override
    public String getQueryDefinition() {
        throw new IllegalArgumentException("Can't get query definition on priority index!");
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof PriorityIndex;
    }

    public int hashCode() {
        return 3155577;
    }

    public String toString() {
        return "PriorityIndex";
    }
}

