/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.client.snapshot;

import com.firebase.client.snapshot.LeafNode;
import com.firebase.client.snapshot.Node;

public class BooleanNode
extends LeafNode<BooleanNode> {
    private final boolean value;

    public BooleanNode(Boolean value, Node priority) {
        super(priority);
        this.value = value;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public String getHashRepresentation(Node.HashVersion version) {
        return this.getPriorityHash(version) + "boolean:" + this.value;
    }

    @Override
    public BooleanNode updatePriority(Node priority) {
        return new BooleanNode(this.value, priority);
    }

    @Override
    protected LeafNode.LeafType getLeafType() {
        return LeafNode.LeafType.Boolean;
    }

    @Override
    protected int compareLeafValues(BooleanNode other) {
        return this.value == other.value ? 0 : (this.value ? 1 : -1);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof BooleanNode)) {
            return false;
        }
        BooleanNode otherBooleanNode = (BooleanNode)other;
        return this.value == otherBooleanNode.value && this.priority.equals(otherBooleanNode.priority);
    }

    @Override
    public int hashCode() {
        return (this.value ? 1 : 0) + this.priority.hashCode();
    }
}

