/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.client.core.view;

import com.firebase.client.core.view.filter.IndexedFilter;
import com.firebase.client.core.view.filter.LimitedFilter;
import com.firebase.client.core.view.filter.NodeFilter;
import com.firebase.client.core.view.filter.RangedFilter;
import com.firebase.client.snapshot.ChildKey;
import com.firebase.client.snapshot.Index;
import com.firebase.client.snapshot.Node;
import com.firebase.client.snapshot.NodeUtilities;
import com.firebase.client.snapshot.PriorityIndex;
import com.shaded.fasterxml.jackson.databind.ObjectMapper;
import com.shaded.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class QueryParams {
    public static final QueryParams DEFAULT_PARAMS = new QueryParams();
    private static final String INDEX_START_VALUE = "sp";
    private static final String INDEX_START_NAME = "sn";
    private static final String INDEX_END_VALUE = "ep";
    private static final String INDEX_END_NAME = "en";
    private static final String LIMIT = "l";
    private static final String VIEW_FROM = "vf";
    private static final String INDEX = "i";
    private static final ObjectMapper mapperInstance = new ObjectMapper();
    private Integer limit;
    private ViewFrom viewFrom;
    private Node indexStartValue = null;
    private ChildKey indexStartName = null;
    private Node indexEndValue = null;
    private ChildKey indexEndName = null;
    private Index index = PriorityIndex.getInstance();
    private String jsonSerialization = null;

    public boolean hasStart() {
        return this.indexStartValue != null;
    }

    public Node getIndexStartValue() {
        if (!this.hasStart()) {
            throw new IllegalArgumentException("Cannot get index start value if start has not been set");
        }
        return this.indexStartValue;
    }

    public ChildKey getIndexStartName() {
        if (!this.hasStart()) {
            throw new IllegalArgumentException("Cannot get index start name if start has not been set");
        }
        if (this.indexStartName != null) {
            return this.indexStartName;
        }
        return ChildKey.getMinName();
    }

    public boolean hasEnd() {
        return this.indexEndValue != null;
    }

    public Node getIndexEndValue() {
        if (!this.hasEnd()) {
            throw new IllegalArgumentException("Cannot get index end value if start has not been set");
        }
        return this.indexEndValue;
    }

    public ChildKey getIndexEndName() {
        if (!this.hasEnd()) {
            throw new IllegalArgumentException("Cannot get index end name if start has not been set");
        }
        if (this.indexEndName != null) {
            return this.indexEndName;
        }
        return ChildKey.getMaxName();
    }

    public boolean hasLimit() {
        return this.limit != null;
    }

    public boolean hasAnchoredLimit() {
        return this.hasLimit() && this.viewFrom != null;
    }

    public int getLimit() {
        if (!this.hasLimit()) {
            throw new IllegalArgumentException("Cannot get limit if limit has not been set");
        }
        return this.limit;
    }

    public Index getIndex() {
        return this.index;
    }

    private QueryParams copy() {
        QueryParams params = new QueryParams();
        params.limit = this.limit;
        params.indexStartValue = this.indexStartValue;
        params.indexStartName = this.indexStartName;
        params.indexEndValue = this.indexEndValue;
        params.indexEndName = this.indexEndName;
        params.viewFrom = this.viewFrom;
        params.index = this.index;
        return params;
    }

    public QueryParams limit(int limit) {
        QueryParams copy = this.copy();
        copy.limit = limit;
        copy.viewFrom = null;
        return copy;
    }

    public QueryParams limitToFirst(int limit) {
        QueryParams copy = this.copy();
        copy.limit = limit;
        copy.viewFrom = ViewFrom.LEFT;
        return copy;
    }

    public QueryParams limitToLast(int limit) {
        QueryParams copy = this.copy();
        copy.limit = limit;
        copy.viewFrom = ViewFrom.RIGHT;
        return copy;
    }

    public QueryParams startAt(Node indexStartValue, ChildKey indexStartName) {
        assert (indexStartValue.isLeafNode() || indexStartValue.isEmpty());
        QueryParams copy = this.copy();
        copy.indexStartValue = indexStartValue;
        copy.indexStartName = indexStartName;
        return copy;
    }

    public QueryParams endAt(Node indexEndValue, ChildKey indexEndName) {
        assert (indexEndValue.isLeafNode() || indexEndValue.isEmpty());
        QueryParams copy = this.copy();
        copy.indexEndValue = indexEndValue;
        copy.indexEndName = indexEndName;
        return copy;
    }

    public QueryParams orderBy(Index index) {
        QueryParams copy = this.copy();
        copy.index = index;
        return copy;
    }

    public boolean isViewFromLeft() {
        return this.viewFrom != null ? this.viewFrom == ViewFrom.LEFT : this.hasStart();
    }

    public Map<String, Object> getWireProtocolParams() {
        HashMap<String, Object> queryObject = new HashMap<String, Object>();
        if (this.hasStart()) {
            queryObject.put(INDEX_START_VALUE, this.indexStartValue.getValue());
            if (this.indexStartName != null) {
                queryObject.put(INDEX_START_NAME, this.indexStartName.asString());
            }
        }
        if (this.hasEnd()) {
            queryObject.put(INDEX_END_VALUE, this.indexEndValue.getValue());
            if (this.indexEndName != null) {
                queryObject.put(INDEX_END_NAME, this.indexEndName.asString());
            }
        }
        if (this.limit != null) {
            queryObject.put(LIMIT, this.limit);
            ViewFrom viewFromToAdd = this.viewFrom;
            if (viewFromToAdd == null) {
                viewFromToAdd = this.hasStart() ? ViewFrom.LEFT : ViewFrom.RIGHT;
            }
            switch (viewFromToAdd) {
                case LEFT: {
                    queryObject.put(VIEW_FROM, LIMIT);
                    break;
                }
                case RIGHT: {
                    queryObject.put(VIEW_FROM, "r");
                }
            }
        }
        if (!this.index.equals(PriorityIndex.getInstance())) {
            queryObject.put(INDEX, this.index.getQueryDefinition());
        }
        return queryObject;
    }

    public boolean loadsAllData() {
        return !this.hasStart() && !this.hasEnd() && !this.hasLimit();
    }

    public boolean isDefault() {
        return this.loadsAllData() && this.index.equals(PriorityIndex.getInstance());
    }

    public boolean isValid() {
        return !this.hasStart() || !this.hasEnd() || !this.hasLimit() || this.hasAnchoredLimit();
    }

    public String toJSON() {
        if (this.jsonSerialization == null) {
            try {
                this.jsonSerialization = mapperInstance.writeValueAsString(this.getWireProtocolParams());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.jsonSerialization;
    }

    public static QueryParams fromQueryObject(Map<String, Object> map) {
        String indexStr;
        String viewFrom;
        QueryParams params = new QueryParams();
        params.limit = (Integer)map.get(LIMIT);
        if (map.containsKey(INDEX_START_VALUE)) {
            Object indexStartValue = map.get(INDEX_START_VALUE);
            params.indexStartValue = NodeUtilities.NodeFromJSON(indexStartValue);
            String indexStartName = (String)map.get(INDEX_START_NAME);
            if (indexStartName != null) {
                params.indexStartName = ChildKey.fromString(indexStartName);
            }
        }
        if (map.containsKey(INDEX_END_VALUE)) {
            Object indexEndValue = map.get(INDEX_END_VALUE);
            params.indexEndValue = NodeUtilities.NodeFromJSON(indexEndValue);
            String indexEndName = (String)map.get(INDEX_END_NAME);
            if (indexEndName != null) {
                params.indexEndName = ChildKey.fromString(indexEndName);
            }
        }
        if ((viewFrom = (String)map.get(VIEW_FROM)) != null) {
            ViewFrom viewFrom2 = params.viewFrom = viewFrom.equals(LIMIT) ? ViewFrom.LEFT : ViewFrom.RIGHT;
        }
        if ((indexStr = (String)map.get(INDEX)) != null) {
            params.index = Index.fromQueryDefinition(indexStr);
        }
        return params;
    }

    public NodeFilter getNodeFilter() {
        if (this.loadsAllData()) {
            return new IndexedFilter(this.getIndex());
        }
        if (this.hasLimit()) {
            return new LimitedFilter(this);
        }
        return new RangedFilter(this);
    }

    public String toString() {
        return this.getWireProtocolParams().toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryParams that = (QueryParams)o;
        if (this.limit != null ? !this.limit.equals(that.limit) : that.limit != null) {
            return false;
        }
        if (this.index != null ? !this.index.equals(that.index) : that.index != null) {
            return false;
        }
        if (this.indexEndName != null ? !this.indexEndName.equals(that.indexEndName) : that.indexEndName != null) {
            return false;
        }
        if (this.indexEndValue != null ? !this.indexEndValue.equals(that.indexEndValue) : that.indexEndValue != null) {
            return false;
        }
        if (this.indexStartName != null ? !this.indexStartName.equals(that.indexStartName) : that.indexStartName != null) {
            return false;
        }
        if (this.indexStartValue != null ? !this.indexStartValue.equals(that.indexStartValue) : that.indexStartValue != null) {
            return false;
        }
        return this.isViewFromLeft() == that.isViewFromLeft();
    }

    public int hashCode() {
        int result = this.limit != null ? this.limit : 0;
        result = 31 * result + (this.isViewFromLeft() ? 1231 : 1237);
        result = 31 * result + (this.indexStartValue != null ? this.indexStartValue.hashCode() : 0);
        result = 31 * result + (this.indexStartName != null ? this.indexStartName.hashCode() : 0);
        result = 31 * result + (this.indexEndValue != null ? this.indexEndValue.hashCode() : 0);
        result = 31 * result + (this.indexEndName != null ? this.indexEndName.hashCode() : 0);
        result = 31 * result + (this.index != null ? this.index.hashCode() : 0);
        return result;
    }

    static {
        mapperInstance.configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);
    }

    private static enum ViewFrom {
        LEFT,
        RIGHT;

    }
}

