/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.client.core.persistence;

import com.firebase.client.collection.ImmutableSortedMap;
import com.firebase.client.core.Path;
import com.firebase.client.core.utilities.ImmutableTree;
import com.firebase.client.core.utilities.Predicate;
import com.firebase.client.snapshot.ChildKey;
import java.util.Set;

public class PruneForest {
    private final ImmutableTree<Boolean> pruneForest;
    private static final Predicate<Boolean> KEEP_PREDICATE = new Predicate<Boolean>(){

        @Override
        public boolean evaluate(Boolean prune) {
            return prune == false;
        }
    };
    private static final Predicate<Boolean> PRUNE_PREDICATE = new Predicate<Boolean>(){

        @Override
        public boolean evaluate(Boolean prune) {
            return prune;
        }
    };
    private static final ImmutableTree<Boolean> PRUNE_TREE = new ImmutableTree<Boolean>(true);
    private static final ImmutableTree<Boolean> KEEP_TREE = new ImmutableTree<Boolean>(false);

    public PruneForest() {
        this.pruneForest = ImmutableTree.emptyInstance();
    }

    private PruneForest(ImmutableTree<Boolean> pruneForest) {
        this.pruneForest = pruneForest;
    }

    public boolean prunesAnything() {
        return this.pruneForest.containsMatchingValue(PRUNE_PREDICATE);
    }

    public boolean shouldPruneUnkeptDescendants(Path path) {
        Boolean shouldPrune = this.pruneForest.leafMostValue(path);
        return shouldPrune != null && shouldPrune != false;
    }

    public boolean shouldKeep(Path path) {
        Boolean shouldPrune = this.pruneForest.leafMostValue(path);
        return shouldPrune != null && shouldPrune == false;
    }

    public boolean affectsPath(Path path) {
        return this.pruneForest.rootMostValue(path) != null || !this.pruneForest.subtree(path).isEmpty();
    }

    public PruneForest child(ChildKey key) {
        ImmutableTree<Boolean> childPruneTree = this.pruneForest.getChild(key);
        if (childPruneTree == null) {
            childPruneTree = new ImmutableTree<Boolean>(this.pruneForest.getValue());
        } else if (childPruneTree.getValue() == null && this.pruneForest.getValue() != null) {
            childPruneTree = childPruneTree.set(Path.getEmptyPath(), this.pruneForest.getValue());
        }
        return new PruneForest(childPruneTree);
    }

    public PruneForest child(Path path) {
        if (path.isEmpty()) {
            return this;
        }
        return this.child(path.getFront()).child(path.popFront());
    }

    public <T> T foldKeptNodes(T startValue, final ImmutableTree.TreeVisitor<Void, T> treeVisitor) {
        return this.pruneForest.fold(startValue, new ImmutableTree.TreeVisitor<Boolean, T>(){

            @Override
            public T onNodeValue(Path relativePath, Boolean prune, T accum) {
                if (!prune.booleanValue()) {
                    return treeVisitor.onNodeValue(relativePath, null, accum);
                }
                return accum;
            }
        });
    }

    public PruneForest prune(Path path) {
        if (this.pruneForest.rootMostValueMatching(path, KEEP_PREDICATE) != null) {
            throw new IllegalArgumentException("Can't prune path that was kept previously!");
        }
        if (this.pruneForest.rootMostValueMatching(path, PRUNE_PREDICATE) != null) {
            return this;
        }
        ImmutableTree<Boolean> newPruneTree = this.pruneForest.setTree(path, PRUNE_TREE);
        return new PruneForest(newPruneTree);
    }

    public PruneForest keep(Path path) {
        if (this.pruneForest.rootMostValueMatching(path, KEEP_PREDICATE) != null) {
            return this;
        }
        ImmutableTree<Boolean> newPruneTree = this.pruneForest.setTree(path, KEEP_TREE);
        return new PruneForest(newPruneTree);
    }

    public PruneForest keepAll(Path path, Set<ChildKey> children) {
        if (this.pruneForest.rootMostValueMatching(path, KEEP_PREDICATE) != null) {
            return this;
        }
        return this.doAll(path, children, KEEP_TREE);
    }

    public PruneForest pruneAll(Path path, Set<ChildKey> children) {
        if (this.pruneForest.rootMostValueMatching(path, KEEP_PREDICATE) != null) {
            throw new IllegalArgumentException("Can't prune path that was kept previously!");
        }
        if (this.pruneForest.rootMostValueMatching(path, PRUNE_PREDICATE) != null) {
            return this;
        }
        return this.doAll(path, children, PRUNE_TREE);
    }

    private PruneForest doAll(Path path, Set<ChildKey> children, ImmutableTree<Boolean> keepOrPruneTree) {
        ImmutableTree<Boolean> subtree = this.pruneForest.subtree(path);
        ImmutableSortedMap childrenMap = subtree.getChildren();
        for (ChildKey key : children) {
            childrenMap = childrenMap.insert(key, keepOrPruneTree);
        }
        return new PruneForest(this.pruneForest.setTree(path, new ImmutableTree<Boolean>(subtree.getValue(), childrenMap)));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PruneForest)) {
            return false;
        }
        PruneForest that = (PruneForest)o;
        return this.pruneForest.equals(that.pruneForest);
    }

    public int hashCode() {
        return this.pruneForest.hashCode();
    }

    public String toString() {
        return "{PruneForest:" + this.pruneForest.toString() + "}";
    }
}

