/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.client.android;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.util.Log;
import com.firebase.client.CredentialStore;
import com.firebase.client.EventTarget;
import com.firebase.client.Firebase;
import com.firebase.client.FirebaseException;
import com.firebase.client.Logger;
import com.firebase.client.RunLoop;
import com.firebase.client.android.AndroidCredentialStore;
import com.firebase.client.android.AndroidEventTarget;
import com.firebase.client.android.AndroidLogger;
import com.firebase.client.android.SqlPersistenceStorageEngine;
import com.firebase.client.core.Platform;
import com.firebase.client.core.persistence.DefaultPersistenceManager;
import com.firebase.client.core.persistence.LRUCachePolicy;
import com.firebase.client.core.persistence.PersistenceManager;
import com.firebase.client.utilities.DefaultRunLoop;
import com.firebase.client.utilities.LogWrapper;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class AndroidPlatform
implements Platform {
    private static final Object mutex = new Object();
    private static AndroidPlatform platform;
    private final Context applicationContext;
    private final Set<String> createdPersistenceCaches = new HashSet<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AndroidPlatform(Context context) {
        this.applicationContext = context.getApplicationContext();
        Object object = mutex;
        synchronized (object) {
            if (platform != null) {
                throw new IllegalStateException("Created more than one AndroidPlatform instance!");
            }
            platform = this;
        }
    }

    @Override
    public EventTarget newEventTarget(com.firebase.client.core.Context context) {
        return new AndroidEventTarget();
    }

    @Override
    public RunLoop newRunLoop(com.firebase.client.core.Context ctx) {
        final LogWrapper logger = ctx.getLogger("RunLoop");
        return new DefaultRunLoop(){

            @Override
            public void handleException(final Throwable e) {
                final String message = "Uncaught exception in Firebase runloop (" + Firebase.getSdkVersion() + "). Please report to support@firebase.com";
                logger.error(message, e);
                Handler handler = new Handler(AndroidPlatform.this.applicationContext.getMainLooper());
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        throw new RuntimeException(message, e);
                    }
                });
            }
        };
    }

    @Override
    public Logger newLogger(com.firebase.client.core.Context context, Logger.Level component, List<String> enabledComponents) {
        return new AndroidLogger(component, enabledComponents);
    }

    @Override
    public String getUserAgent(com.firebase.client.core.Context context) {
        return Build.VERSION.SDK_INT + "/Android";
    }

    @Override
    public void runBackgroundTask(com.firebase.client.core.Context context, final Runnable r) {
        new Thread(){

            @Override
            public void run() {
                try {
                    r.run();
                }
                catch (OutOfMemoryError e) {
                    throw e;
                }
                catch (Throwable e) {
                    Log.e((String)"Firebase", (String)"An unexpected error occurred. Please contact support@firebase.com. Details: ", (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
        }.start();
    }

    @Override
    public String getPlatformVersion() {
        return "android-" + Firebase.getSdkVersion();
    }

    @Override
    public synchronized PersistenceManager createPersistenceManager(com.firebase.client.core.Context firebaseContext, String firebaseId) {
        String sessionId = firebaseContext.getSessionPersistenceKey();
        String cacheId = firebaseId + "_" + sessionId;
        if (this.createdPersistenceCaches.contains(cacheId)) {
            throw new FirebaseException("SessionPersistenceKey '" + sessionId + "' has already been used.");
        }
        this.createdPersistenceCaches.add(cacheId);
        SqlPersistenceStorageEngine engine = new SqlPersistenceStorageEngine(this.applicationContext, firebaseContext, cacheId);
        LRUCachePolicy cachePolicy = new LRUCachePolicy(firebaseContext.getPersistenceCacheSizeBytes());
        return new DefaultPersistenceManager(firebaseContext, engine, cachePolicy);
    }

    @Override
    public CredentialStore newCredentialStore(com.firebase.client.core.Context context) {
        return new AndroidCredentialStore(this.applicationContext);
    }
}

